


        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })
        document.addEventListener('DOMContentLoaded', function() {
          const skypeButton = document.getElementById('skypeButton');
        
          if (skypeButton) {
          const skypeAdd = document.getElementById('skypeButton').innerHTML;
            skypeButton.addEventListener('click', function() {
              const skypeURI = `skype:${skypeAdd}?chat`;
              window.location.href = skypeURI;
            });
          }
        });
        
        var timerID = setInterval(function() {
        now = new Date();
        timezone = now.getTimezoneOffset();
        day = now.getDay();
        hour = now.getUTCHours();
        min = now.getUTCMinutes();
        sec = now.getUTCSeconds();
        ms = now.getUTCMilliseconds();

        displayTime(hour, min, sec, day, "AM", -5, "time-atx", "day-atx");
        }, 1000);

        function displayTime(hour, min, sec, day, meridiem, offset, timeId, dayId) {

        hour = hour + offset;
        if (hour < 0) {
            hour = 24 + hour;
            day--;
        } else if (hour >= 24) {
            hour = hour - 24;
            day++;
        }


        if (hour > 12) {
            hour = hour - 12;
            meridiem = "PM";
        }
        if (hour === 0)
            hour = 12;

        if (hour < 10)
            hour = "0" + hour;
        if (min < 10)
            min = "0" + min;
        if (sec < 10)
            sec = "0" + sec;

        $('#dashHours').html(hour);
        $('#dashMin').html(min);
        $('#dashSec').html(sec);
    }
    


        $(document).ready(function() {
            "use strict"

            //show response message
            function showResponseMessage(data) {

                if (data.status === 'success') {
                    toastr['success'](data.message, 'User Status Changes Success!!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                    });
                    dataListView.draw();
                } else {
                    toastr['warning']("Something Went To Wrong ", 'locale.labels.warning!', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                        progressBar: true,
                        newestOnTop: true,
                    });
                }
            }

            // init table dom
            let Table = $("table");
            // init list view datatable
            let dataListView = $('.datatables-basic').DataTable({
                lengthChange: false,
                sScrollX: "100%",
                autoWidth: false,
                processing: true,
                "serverSide": true,
                "ajax": {
                    "url": "https://trackergenius.runterminal.com/admin/user/search",
                    "dataType": "json",
                    "type": "POST",
                    "data": {
                        _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB"
                    }
                },
                "columns": [{
                        "data": 'id',
                        orderable: false,
                        searchable: false
                    },
                    {
                        "data": "id"
                    },
                    {
                        "data": "id"
                    },
                    {
                        "data": "name",
                        orderable: false,
                        searchable: false
                    },
                    {
                        "data": "status",
                        orderable: false,
                        searchable: false
                    },
                    {
                        "data": "action",
                        orderable: false,
                        searchable: false
                    }
                ],

                searchDelay: 1500,
                columnDefs: [{
                        className: 'control',
                        orderable: false,
                        responsivePriority: 2,
                        targets: 2
                    },
                    {
                        // For Checkboxes
                        targets: 1,
                        orderable: false,
                        responsivePriority: 3,
                        render: function(data) {
                            return (
                                '<div class="form-check"> <input class="form-check-input dt-checkboxes" type="checkbox" value="" id="' +
                                data +
                                '" /><label class="form-check-label" for="' +
                                data +
                                '"></label></div>'
                            );
                        },
                        checkboxes: {
                            selectAllRender: '<div class="form-check"> <input class="form-check-input" type="checkbox" value="" id="checkboxSelectAll" /><label class="form-check-label" for="checkboxSelectAll"></label></div>',
                            selectRow: true
                        }
                    },
                    {
                        targets: 2,
                        visible: false
                    },
                    {
                        // Avatar image/badge, Name and post
                        targets: 3,
                        responsivePriority: 1,
                        render: function(data, type, full) {
                            var $user_img = full['avatar'],
                                $name = full['name'],
                                $created_at = full['created_at'],
                                $email = full['email'];
                            if ($user_img) {
                                // For Avatar image
                                var $output =
                                    '<img src="' + $user_img +
                                    '" alt="Avatar" width="32" height="32">';
                            } else {
                                // For Avatar badge
                                var stateNum = full['status'];
                                var states = ['success', 'danger', 'warning', 'info', 'dark',
                                    'primary', 'secondary'
                                ];
                                var $state = states[stateNum],
                                    $name = full['name'],
                                    $initials = $name.match(/\b\w/g) || [];
                                $initials = (($initials.shift() || '') + ($initials.pop() || ''))
                                    .toUpperCase();
                                $output = '<span class="avatar-content">' + $initials + '</span>';
                            }

                            var colorClass = $user_img === '' ? ' bg-light-' + $state + ' ' : '';
                            // Creates full output for row
                            return '<div class="d-flex justify-content-left align-items-center">' +
                                '<div class="avatar ' +
                                colorClass +
                                ' me-1">' +
                                $output +
                                '</div>' +
                                '<div class="d-flex flex-column">' +
                                '<span class="emp_name text-truncate fw-bold">' +
                                $name +
                                '</span>' +
                                '<small class="emp_post text-truncate text-muted">' +
                                $email +
                                '</small>' +
                                '<small class="emp_post text-truncate text-muted">' +
                                $created_at +
                                '</small>' +
                                '</div>' +
                                '</div>';
                        }
                    },
                    {
                        // Actions
                        targets: -1,
                        title: 'Action',
                        orderable: false,
                        render: function(data, type, full) {
                            var $super_user = '';
                            let deletetnb= ' ';
                            
                             if(full['auth_id']==1){
                                  deletetnb = '<a href="' + full['delete'] +
                                '" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="top" title="' +
                                "Delete" + '">' +
                                feather.icons['trash'].toSvg({
                                    class: 'font-medium-4'
                                }) +
                                '</a>'    
                                
                                }
                            

                            if (full['super_user'] === true) {
                                $super_user =
                                    '<span class="action-delete text-danger pe-1 cursor-pointer" data-bs-toggle="tooltip" data-bs-placement="top" title=' +
                                    full['delete_label'] + ' data-id=' + full['delete'] + '>' +
                                    feather.icons['trash'].toSvg({
                                        class: 'font-medium-4'
                                    }) +
                                    '</span>';
                            }
                            return (
                                '<span class="d-flex">' +
                                $super_user +
                                '<a href="' + full['edit'] +
                                '" class="text-primary pe-1" data-bs-toggle="tooltip" data-bs-placement="top" title=' +
                                "Edit" + '>' +
                                feather.icons['edit'].toSvg({
                                    class: 'font-medium-4'
                                })+'</a>'+deletetnb +
                                '</span>'
                            );
                        }
                    }
                ],
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row mb-2"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',

                language: {
                    paginate: {
                        // remove previous & next text from pagination
                        previous: '&nbsp;',
                        next: '&nbsp;'
                    },
                    sLengthMenu: "_MENU_",
                    sZeroRecords: "No Result",
                    sSearch: "Search",
                    sProcessing: "Processing...",
                    sInfo: "Show "
                },
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({
                            header: function(row) {
                                let data = row.data();
                                return 'Details of ' + data['name'];
                            }
                        }),
                        type: 'column',
                        renderer: function(api, rowIdx, columns) {
                            let data = $.map(columns, function(col) {
                                return col.title !==
                                    '' // ? Do not show row in modal popup if title is blank (for check box)
                                    ?
                                    '<tr data-dt-row="' +
                                    col.rowIdx +
                                    '" data-dt-column="' +
                                    col.columnIndex +
                                    '">' +
                                    '<td>' +
                                    col.title +
                                    ':' +
                                    '</td> ' +
                                    '<td>' +
                                    col.data +
                                    '</td>' +
                                    '</tr>' :
                                    '';
                            }).join('');

                            return data ? $('<table class="table"/>').append('<tbody>' + data +
                                '</tbody>') : false;
                        }
                    }
                },
                aLengthMenu: [
                    [10, 20, 50, 100],
                    [10, 20, 50, 100]
                ],
                select: {
                    style: "multi"
                },
                order: [
                    [2, "desc"]
                ],
                displayLength: 10,
            });


            Table.delegate(".get_status", "click", function() {
                let customer = $(this).data('id');
                $.ajax({
                    url: "https://trackergenius.runterminal.com/admin/user/active",
                    type: "POST",
                    data: {
                        id: customer,
                        _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB"
                    },
                    success: function(data) {
                        showResponseMessage(data);
                    }
                });
            });

            // On Delete
            Table.delegate(".action-delete", "click", function(e) {
                e.stopPropagation();
                let id = $(this).data('id');
                Swal.fire({
                    title: "Are you sure?",
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "Deleted IT",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function(result) {
                    if (result.value) {
                        $.ajax({
                            url: "https://trackergenius.runterminal.com/customers" +
                                '/' +
                                id,
                            type: "POST",
                            data: {
                                _method: 'DELETE',
                                _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB"
                            },
                            success: function(data) {
                                showResponseMessage(data);
                            },
                            error: function(reject) {
                                if (reject.status === 422) {
                                    let errors = reject.responseJSON.errors;
                                    $.each(errors, function(key, value) {
                                        toastr['warning'](value[0],
                                            "Attention", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                    });
                                } else {
                                    toastr['warning'](reject.responseJSON.message,
                                        "locale.labels.attention", {
                                            positionClass: 'toast-top-right',
                                            containerId: 'toast-top-right',
                                            progressBar: true,
                                            closeButton: true,
                                            newestOnTop: true
                                        });
                                }
                            }
                        })
                    }
                })
            });


            //Bulk Enable
            $(".bulk-enable").on('click', function(e) {
                e.preventDefault();

                Swal.fire({
                    title: "Are u Sure?",
                    text: "Enable Customer",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "Enable Selected",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,

                }).then(function(result) {
                    if (result.value) {
                        let customer_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();
                        $.each(rows_selected, function(index, rowId) {
                            customer_ids.push(rowId)
                        });

                        if (customer_ids.length > 0) {
                            $.ajax({
                                url: "https://trackergenius.runterminal.com/admin/user/bulk-action",
                                type: "POST",
                                data: {
                                    _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB",
                                    action: 'Approved',
                                    ids: customer_ids
                                },
                                success: function(data) {
                                    showResponseMessage(data);
                                },
                                error: function(reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function(key, value) {
                                            toastr['warning'](value[0],
                                                "locale.labels.attention", {
                                                    closeButton: true,
                                                    positionClass: 'toast-top-right',
                                                    progressBar: true,
                                                    newestOnTop: true,
                                                    rtl: isRtl
                                                });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message,
                                            "locale.labels.attention", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("locale.labels.at_least_one_data",
                                "locale.labels.attention", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                        }
                    }
                })
            });

            //Bulk disable
            $(".bulk-disable").on('click', function(e) {

                e.preventDefault();

                Swal.fire({
                    title: "Are u Sure?",
                    text: "Disable Customer",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "Disable Selected",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function(result) {
                    if (result.value) {
                        let customer_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();

                        $.each(rows_selected, function(index, rowId) {
                            customer_ids.push(rowId)
                        });

                        if (customer_ids.length > 0) {

                            $.ajax({
                                url: "https://trackergenius.runterminal.com/admin/user/bulk-action",
                                type: "POST",
                                data: {
                                    _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB",
                                    action: 'Pending',
                                    ids: customer_ids
                                },
                                success: function(data) {
                                    showResponseMessage(data);
                                },
                                error: function(reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function(key, value) {
                                            toastr['warning'](value[0],
                                                "locale.labels.attention", {
                                                    closeButton: true,
                                                    positionClass: 'toast-top-right',
                                                    progressBar: true,
                                                    newestOnTop: true,
                                                    rtl: isRtl
                                                });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message,
                                            "locale.labels.attention", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("locale.labels.at_least_one_data",
                                "locale.labels.attention", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                        }

                    }
                })
            });

            // bulk suspend
            $(".bulk-suspend").on('click', function(e) {
                e.preventDefault();
                Swal.fire({
                    title: "Are u Sure?",
                    text: "Disable Customer",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: "Suspend Selected",
                    customClass: {
                        confirmButton: 'btn btn-primary',
                        cancelButton: 'btn btn-outline-danger ms-1'
                    },
                    buttonsStyling: false,
                }).then(function(result) {
                    if (result.value) {
                        let customer_ids = [];
                        let rows_selected = dataListView.column(1).checkboxes.selected();
                        $.each(rows_selected, function(index, rowId) {
                            customer_ids.push(rowId)
                        });
                        if (customer_ids.length > 0) {
                            $.ajax({
                                url: "https://trackergenius.runterminal.com/admin/user/bulk-action",
                                type: "POST",
                                data: {
                                    _token: "xVg5vlGiMwfiDk04qzHQhHjes4QkM1yoxS7WeOHB",
                                    action: 'Suspend',
                                    ids: customer_ids
                                },
                                success: function(data) {
                                    showResponseMessage(data);
                                },
                                error: function(reject) {
                                    if (reject.status === 422) {
                                        let errors = reject.responseJSON.errors;
                                        $.each(errors, function(key, value) {
                                            toastr['warning'](value[0],
                                                "locale.labels.attention", {
                                                    closeButton: true,
                                                    positionClass: 'toast-top-right',
                                                    progressBar: true,
                                                    newestOnTop: true,
                                                    rtl: isRtl
                                                });
                                        });
                                    } else {
                                        toastr['warning'](reject.responseJSON.message,
                                            "locale.labels.attention", {
                                                closeButton: true,
                                                positionClass: 'toast-top-right',
                                                progressBar: true,
                                                newestOnTop: true,
                                                rtl: isRtl
                                            });
                                    }
                                }
                            })
                        } else {
                            toastr['warning']("locale.labels.at_least_one_data",
                                "locale.labels.attention", {
                                    closeButton: true,
                                    positionClass: 'toast-top-right',
                                    progressBar: true,
                                    newestOnTop: true,
                                    rtl: isRtl
                                });
                        }

                    }
                })
            });
        });
    